﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.Facade.Data;
using BMS.Web.Controllers.Shared;
using System.ComponentModel.DataAnnotations;
using BMS.Utils;
using BMS.Web.App_GlobalResource;

namespace BMS.Web.Models
{
    public class ContingencySettingsViewModel : BaseViewModel
    {
        public List<Division> Divisions
        {
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    DivisionList = new List<ContingencySettings>();
                    if (value != null)
                    {
                        //foreach (CodeFilterParametersWithProperty item in value)
                        foreach (Division div in value)
                        {
                            DivisionList.Add(new ContingencySettings() { Division = div, WhiteboardReportPath = div.WhiteboardReportPath });
                        }
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        public List<ContingencySettings> DivisionList { get; set; }
    }

    public class ContingencySettings : BaseViewModel
    {
        public Division Division { get; set; }

        [RegularExpression(Constants.CONTINGENCY_REGULAR_EXPRESSION, ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "ContingencyInvalidWhiteboarReportPath")]
        public string WhiteboardReportPath { get; set; }

    }
}